/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs.particles;

import com.almostreliable.ponderjs.particles.ParticleTransformation;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.particle.RotationIndicatorParticleData;
import com.simibubi.create.foundation.utility.Color;
import dev.latvian.mods.rhino.mod.wrapper.ColorWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1160;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_5743;
import net.minecraft.class_5744;

public abstract class ParticleDataBuilder<O extends ParticleDataBuilder<O, PO>, PO extends class_2394> {
    final List<ParticleTransformation> transformations = new ArrayList<ParticleTransformation>();
    int density = 1;
    @Nullable
    Float gravity = null;
    @Nullable
    Boolean physics = null;
    @Nullable
    Boolean collision = null;
    @Nullable
    dev.latvian.mods.rhino.mod.util.color.Color color = null;
    @Nullable
    Float roll = null;
    @Nullable
    Float friction = null;
    @Nullable
    Float scale = null;
    @Nullable
    Integer lifetime = null;

    public O density(int density) {
        this.density = density;
        return this.getSelf();
    }

    public O gravity(float gravity) {
        this.gravity = Float.valueOf(gravity);
        return this.getSelf();
    }

    public O physics(boolean physics) {
        this.physics = physics;
        return this.getSelf();
    }

    public O collision(boolean collision) {
        this.collision = collision;
        return this.getSelf();
    }

    public O color(dev.latvian.mods.rhino.mod.util.color.Color color) {
        this.color = color;
        return this.getSelf();
    }

    public O roll(float roll) {
        this.roll = Float.valueOf(roll);
        return this.getSelf();
    }

    public O friction(float friction) {
        this.friction = Float.valueOf(friction);
        return this.getSelf();
    }

    public O scale(float scale) {
        this.scale = Float.valueOf(scale);
        return this.getSelf();
    }

    public O lifetime(int lifetime) {
        this.lifetime = lifetime;
        return this.getSelf();
    }

    public O motion(class_243 motion) {
        return this.transformMotion((partialTicks, m) -> motion);
    }

    public O speed(class_243 speed) {
        return this.transformMotion((partialTick, motion) -> new class_243(Create.RANDOM.method_43059() * speed.field_1352, Create.RANDOM.method_43059() * speed.field_1351, Create.RANDOM.method_43059() * speed.field_1350));
    }

    public O withinBlockSpace() {
        return this.transformPosition((partialTicks, position) -> new class_243(Math.floor(position.field_1352) + (double)Create.RANDOM.method_43057(), Math.floor(position.field_1351) + (double)Create.RANDOM.method_43057(), Math.floor(position.field_1350) + (double)Create.RANDOM.method_43057()));
    }

    public O area(class_243 area) {
        return this.transformPosition((partialTicks, position) -> new class_243(position.field_1352 + (double)Create.RANDOM.method_43057() * (area.field_1352 - position.field_1352), position.field_1351 + (double)Create.RANDOM.method_43057() * (area.field_1351 - position.field_1351), position.field_1350 + (double)Create.RANDOM.method_43057() * (area.field_1350 - position.field_1350)));
    }

    public O delta(class_243 delta) {
        return this.transformPosition((partialTicks, position) -> new class_243(position.field_1352 + Create.RANDOM.method_43059() * delta.field_1352, position.field_1351 + Create.RANDOM.method_43059() * delta.field_1351, position.field_1350 + Create.RANDOM.method_43059() * delta.field_1350));
    }

    public O transform(ParticleTransformation transformer) {
        this.transformations.add(transformer);
        return this.getSelf();
    }

    public O transformPosition(ParticleTransformation.Simple transformer) {
        return this.transform(ParticleTransformation.onlyPosition(transformer));
    }

    public O transformMotion(ParticleTransformation.Simple transformer) {
        return this.transform(ParticleTransformation.onlyMotion(transformer));
    }

    abstract PO createOptions();

    protected O getSelf() {
        return (O)this;
    }

    public static class RotationIndicatorParticleDataBuilder
    extends ParticleDataBuilder<RotationIndicatorParticleDataBuilder, RotationIndicatorParticleData> {
        private final float radius1;
        private final float radius2;
        private final class_2350.class_2351 axis;
        private float rotationSpeed = 1.0f;

        public RotationIndicatorParticleDataBuilder(float radius1, float radius2, class_2350.class_2351 axis) {
            this.radius1 = radius1;
            this.radius2 = radius2;
            this.axis = axis;
        }

        public RotationIndicatorParticleDataBuilder rotationSpeed(float rotationSpeed) {
            this.rotationSpeed = rotationSpeed;
            return (RotationIndicatorParticleDataBuilder)this.getSelf();
        }

        @Override
        RotationIndicatorParticleData createOptions() {
            dev.latvian.mods.rhino.mod.util.color.Color c = this.color == null ? ColorWrapper.BLACK : this.color;
            char axisChar = this.axis.name().charAt(0);
            int lTime = this.lifetime == null ? 40 : this.lifetime;
            return new RotationIndicatorParticleData(c.getRgbJS(), this.rotationSpeed, this.radius1, this.radius2, lTime, axisChar);
        }
    }

    public static class DustParticleDataBuilder
    extends ParticleDataBuilder<DustParticleDataBuilder, class_5744> {
        final dev.latvian.mods.rhino.mod.util.color.Color fromColor;
        @Nullable
        final dev.latvian.mods.rhino.mod.util.color.Color toColor;

        public DustParticleDataBuilder(dev.latvian.mods.rhino.mod.util.color.Color fromColor, @Nullable dev.latvian.mods.rhino.mod.util.color.Color toColor) {
            this.fromColor = fromColor;
            this.toColor = toColor;
        }

        @Override
        public DustParticleDataBuilder color(dev.latvian.mods.rhino.mod.util.color.Color color) {
            return this;
        }

        @Override
        class_5744 createOptions() {
            float s = this.scale == null ? 1.0f : this.scale.floatValue();
            class_1160 fC = new Color(this.fromColor.getRgbJS()).asVectorF();
            if (this.toColor == null) {
                return new class_2390(fC, s);
            }
            class_1160 toC = new Color(this.toColor.getRgbJS()).asVectorF();
            return new class_5743(fC, toC, s);
        }
    }

    public static class Static
    extends ParticleDataBuilder<Static, class_2394> {
        private final class_2394 type;

        public Static(class_2394 type) {
            this.type = type;
        }

        @Override
        class_2394 createOptions() {
            return this.type;
        }
    }
}

